-- Anonymer Nutzer für Authorisierung von User-Logins für PostgREST
--- hat nur Zugriff auf Funktion: api.login(username text, password text)


DO $$
BEGIN
  -- TODO TSystem.create__user
  IF NOT EXISTS (SELECT true FROM pg_catalog.pg_roles WHERE rolname = 'sys_postgrest_anon') THEN
    EXECUTE 'CREATE ROLE "sys_postgrest_anon" NOINHERIT;';
  END IF;

  IF NOT EXISTS (SELECT true FROM pg_catalog.pg_roles WHERE rolname = 'SYS.REST-User') THEN
  EXECUTE 'CREATE ROLE "SYS.REST-User" NOINHERIT;';
  END IF;

  IF NOT EXISTS (SELECT true FROM pg_catalog.pg_roles WHERE rolname = 'sys_postgrest_auth') THEN
    EXECUTE 'CREATE ROLE "sys_postgrest_auth" LOGIN NOINHERIT NOCREATEDB NOCREATEROLE NOSUPERUSER PASSWORD ' || quote_literal(TSystem.generate_random_string(20) );
  END IF;

END $$ LANGUAGE plpgsql;


GRANT "sys_postgrest_anon" TO "sys_postgrest_auth";
GRANT "SYS.REST-User" TO "sys_postgrest_auth"; -- sys_postgrest_auth benötigt die Berechtigung um auf die Login-Rolle des Users zu wechseln
--GRANT "CIMPCS" TO "SYS.REST-User";

GRANT USAGE ON SCHEMA api TO "sys_postgrest_anon";
GRANT USAGE ON SCHEMA api TO "sys_postgrest_auth";


-- Konfiguration der Schemas für PostgREST
---- https://postgrest.org/en/stable/api-reference.html#db-schemas
-- Secret für Generierung des JSON Web Token (JWT)
DO $$
BEGIN
  EXECUTE 'ALTER DATABASE ' || quote_ident(current_database()) || ' SET pgrst.db_schemas = ' || quote_literal( 'api, public, x_900_export, x_950_import, twawi' );
  EXECUTE 'ALTER DATABASE ' || quote_ident(current_database()) || ' SET pgrst.jwt_secret = ' || quote_literal( TSystem.generate_random_string(32) );
END $$ LANGUAGE plpgsql;


-- Datei-Tabelle für das Speichern von Dateien für die Webseiten
CREATE TABLE IF NOT EXISTS api.files(
    id   varchar primary key,
    file bytea,
    type text,
    name text
  );

  /*
  -- z.B. Upload Prodat-Logo
  INSERT INTO api.files
  SELECT 'prodat_logo_pfeil', pg_read_binary_file('Y:\\_Archiv_n_Trash\\Trash\\LogoPRODAT_Pfeil.png'), 'image/png', 'prodat_logo_pfeil.png';

  -- z.B. HTMX- und PicoCSS-Dateien lokal verfügbar machen
  INSERT INTO api.files
  SELECT 'htmx.js_v2.0.4', pg_read_binary_file('Y:\\_Archiv_n_Trash\\Trash\\htmx.js'), 'text/javascript', 'htmx.js';
  INSERT INTO api.files
  SELECT 'pico.min.css_v2.1.1', pg_read_binary_file('Y:\\_Archiv_n_Trash\\Trash\\pico.min.css'), 'text/css', 'pico.min.css';
  */

-- Service-Worker-Beispiel für Caching von Webseiten
/*INSERT INTO api.files (id, file, type, name)
VALUES (
  'service-worker-v1',
  $$
const CACHE_NAME = "inventur-cache-v1";
const urlsToCache = [
  "/inventur",
  "https://unpkg.com/@picocss/pico@latest/css/pico.min.css",
  "https://unpkg.com/htmx.org@1.9.5",
  "https://unpkg.com/@ericblade/quagga2@1.2.6/dist/quagga.min.js"
];

// Beim Installieren: Ressourcen cachen
self.addEventListener("install", (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME).then(cache => cache.addAll(urlsToCache))
  );
});

// Bei Fetch: Erst Cache, dann Netzwerk
self.addEventListener("fetch", (event) => {
  if (event.request.method === "GET") {
    event.respondWith(
      caches.match(event.request).then(response =>
        response || fetch(event.request)
      )
    );
  }
});
$$::text::bytea,
  'application/javascript',
  'service-worker.js'
);
*/

-- Tabelle für API-Token
-- Diese Token können für die Authentifizierung von API-Clients verwendet werden
CREATE TABLE IF NOT EXISTS x_10_interfaces.api_token
  (
    api_id           SERIAL PRIMARY KEY,
    api_name         varchar,        -- Name des API-Anbieters, z.B. CERPRO, PRODAT-ERP
    api_user         varchar,        -- Nutzername für den API-Zugriff
    api_token        varchar,        -- Token für den API-Zugriff
    api_params       jsonb,          -- Parameter für Erstellung des API-Tokens, z.B. { "ll_minr": 815 } bei PRODAT-ERP
    api_tokenexpires timestamp NULL  -- Ablaufdatum des Tokens, NULL wenn Token nicht abläuft
  );
CREATE UNIQUE INDEX IF NOT EXISTS api_token__api_name_unique
    ON x_10_interfaces.api_token USING btree
    (api_name ASC NULLS LAST, api_user ASC NULLS LAST, api_params);